select   daten.Bezeichnung,
         daten.Kuerzel,
         daten.VKZ as Vorgangskennzeichen,

         sum(daten.Jahr1) as "Jahressumme vor 5 Jahren",
         sum(daten.Jahr2) as "Jahressumme vor 4 Jahren",
         sum(daten.Jahr3) as "Jahressumme vor 3 Jahren",
         sum(daten.Jahr4) as "Jahressumme vor 2 Jahren",
         sum(daten.Jahr5) as "Jahressumme vor 1 Jahr"
         
from     ( 

         select   'Basiszahl 300.2' as Bezeichnung,
                  nvl(k.kennzeichen,'(ohne)') as Kuerzel,
                  nvl(k.bezeichnung,'(ohne)') as VKZ,

                  count(distinct(case when to_number(to_char(m.bisdatum,'yyyy')) = to_number(to_char(sysdate,'yyyy'))-5 then h.massnahme else null end)) as Jahr1,
                  count(distinct(case when to_number(to_char(m.bisdatum,'yyyy')) = to_number(to_char(sysdate,'yyyy'))-4 then h.massnahme else null end)) as Jahr2,
                  count(distinct(case when to_number(to_char(m.bisdatum,'yyyy')) = to_number(to_char(sysdate,'yyyy'))-3 then h.massnahme else null end)) as Jahr3,
                  count(distinct(case when to_number(to_char(m.bisdatum,'yyyy')) = to_number(to_char(sysdate,'yyyy'))-2 then h.massnahme else null end)) as Jahr4,
                  count(distinct(case when to_number(to_char(m.bisdatum,'yyyy')) = to_number(to_char(sysdate,'yyyy'))-1 then h.massnahme else null end)) as Jahr5
                                                                                                                                            

         from     n_vorgang v inner join n_vorgmassnahme h on v.vorgangsnummer = h.vorgang
                              inner join n_hzestatistik s on h.massnahme = s.massnahmennummer
                              inner join n_massnahme m on h.massnahme = m.massnahmennummer
                              left join n_kennz k on v.kennz_fk = k.lfdnr
                              
         where    to_number(to_char(m.bisdatum,'yyyy')) >= to_number(to_char(sysdate,'yyyy'))-5
         and      s.beendigungsgrund = '20'
         and      s.artderhilfe in ('04','05','06','07','08','09','10','11','12','14','15','16')
         and      s.freigegeben = '1'  
          
          group by  nvl(k.kennzeichen,'(ohne)'),
                    nvl(k.bezeichnung,'(ohne)')

         ) daten
         
group by daten.Bezeichnung,
         daten.Kuerzel,
         daten.VKZ

order by daten.Bezeichnung,
         daten.Kuerzel,
         daten.VKZ